*-------------------------------------------------------------------------------
*						Fig 1
*-------------------------------------------------------------------------------

** Set Path
global Raw_data    	"G:\project-finished\Descriptive\Data"
global App_data    	"G:\project-finished\Descriptive\Appendix Data"
global Class_data   "G:\project-finished\Descriptive\Classification"  
global Work_lab   	"G:\project-finished\Descriptive\Lab"
global Out_lab    	"G:\project-finished\Descriptive\Out" 

cd "$Work_lab"
                            
capture log close            
log using "$Out_lab\Fig 1", replace 
set more off     


**------------------------------------------------------------------------------
* Step1: Generate Data
**------------------------------------------------------------------------------
clear
clear all

//empty file for processed data
clear
set obs 0
save plotdata,replace emptyok

//Define 10 quantile according to initial employment share in 2000
use "whole_occ2015.dta",clear
append using "whole_occ2010.dta"
append using "whole_occ2000.dta"

//keep occupation exist in both period
bys occ_number occ_name:egen num=count(share)
keep if num==3

keep occ_number occ_name share year

reshape wide share,i(occ_number occ_name) j(year)
xtile group = share2000, nq(10)

append using plotdata
save plotdata,replace

gen d_share0015=share2015-share2000

//increase value vs decrease value
gen temp_num=0
replace temp_num=d_share0015 if d_share0015>0
bys group:egen tot_up=sum(temp_num)
drop temp_num

gen temp_num=0
replace temp_num=d_share0015 if d_share0015<0
bys group:egen tot_down=sum(temp_num)
drop temp_num

keep group tot_up tot_down
duplicates drop 

**---------------------------------------
* Step2: Plot
**---------------------------------------
graph bar tot_up tot_down, stack over(group) ytitle("变动幅度总和（%）") scheme(plotplain) ///
legend(position(6) rows(1)  order(1 "上升职业" 2 "下降职业")) ///
bar(1, color(red)) bar(2, color(black))  ylabel(,nogrid) yline(0,lp(solid)) ///
xsize(4) ysize(5)
graph save "$Out_lab\Fig1_a",replace
graph export "$Out_lab\Fig1_a.png",replace


drop if group==10
graph bar tot_up tot_down, stack over(group) ytitle("变动幅度总和（%）") scheme(plotplain) ///
legend(position(6) rows(1)  order(1 "上升职业" 2 "下降职业")) ///
bar(1, color(red)) bar(2, color(black))  ylabel(-4(2)6,nogrid) yline(0,lp(solid)) ///
xsize(4) ysize(5)
graph save "$Out_lab\Fig1_b",replace
graph export "$Out_lab\Fig1_b.png",replace

use plotdata,clear
keep if group==10
gsort -share2000
keep in 1/15

gen rank=_n
replace occ_name="交通运输和设备操作员" if occ_name=="轨道交通运输机械设备操作及有关人员"
replace occ_name="纺织和服装剪裁员" if occ_name=="纺织品和服装剪裁缝纫人员"

graph bar share2000 share2010 share2015, over(occ_name,sort(rank)) ///
horizontal scheme(plotplain) legend(label(1 "2000") label(2 "2010") label(3 "2015") position(6) row(1)) ///
xsize(4) ysize(5) blabel(bar,format(%9.2f) size(2))
graph save "$Out_lab\Fig1_c",replace
graph export "$Out_lab\Fig1_c.png",replace

erase plotdata.dta

log close
